
IF  NOT EXISTS (SELECT * FROM sys.objects 
WHERE object_id = OBJECT_ID(N'[dbo].[EST_SNGPC_REINICIO_INVENTARIO_IT_TEMP]') AND type in (N'U'))
BEGIN

CREATE TABLE [dbo].[EST_SNGPC_REINICIO_INVENTARIO_IT_TEMP](
    [CD_REINICIO] [int] NOT NULL,
    [CD_EMP] [int] NOT NULL,
    [CD_FILIAL] [int] NOT NULL,
    [CD_PROD] [int] NOT NULL,
    [CD_LOTE] [int] NOT NULL,
    [QT_ATUAL] [int] NULL,
    [QT_INVENTARIO] [int] NULL, --QTDE CONTADA
    [CD_USU] [int] NULL,
    [NM_MAQUINA] VARCHAR(500) NOT NULL,
    [DT_CAD] [datetime] NOT NULL DEFAULT( GETDATE() ),
    [QT_GESTAO] [int] NULL, --QTDE DE ESTOQUE GERAL
 CONSTRAINT [PK_EST_SNGPC_REINICIO_INVENTARIO_IT_TEMP] PRIMARY KEY CLUSTERED
(    
    [CD_EMP] ASC,
    [CD_FILIAL] ASC,
    [CD_PROD] ASC,
    [CD_LOTE] ASC,
    [NM_MAQUINA] ASC )
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 97) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_SNGPC_REINICIO_INVENTARIO_IT_TEMP] ADD  CONSTRAINT [DF__EST_SNGPC__IT_TEMP__23274E12]  DEFAULT ((0)) FOR [QT_ATUAL]


ALTER TABLE [dbo].[EST_SNGPC_REINICIO_INVENTARIO_IT_TEMP] ADD  CONSTRAINT [DF__EST_SNGPC__IT_TEMP__241B724B]  DEFAULT ((0)) FOR [QT_INVENTARIO]


ALTER TABLE [dbo].[EST_SNGPC_REINICIO_INVENTARIO_IT_TEMP]  WITH CHECK ADD  CONSTRAINT [FK_EST_SNGPC_REINICIO_INVENTARIO_IT_TEMP_EST_PROD_EST_SNGPC_LOTE_CPL] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_LOTE])
REFERENCES [dbo].[EST_PROD_EST_SNGPC_LOTE_CPL] ([CD_EMP], [CD_FILIAL], [CD_LOTE])
ON UPDATE CASCADE
ON DELETE CASCADE


ALTER TABLE [dbo].[EST_SNGPC_REINICIO_INVENTARIO_IT_TEMP] CHECK CONSTRAINT [FK_EST_SNGPC_REINICIO_INVENTARIO_IT_TEMP_EST_PROD_EST_SNGPC_LOTE_CPL]


END